<?php
include '../../../config.inc.php';
date_default_timezone_set('Asia/Shanghai');
$trade_no = isset($_POST['trade_no']) ? $_POST['trade_no'] : '';
$content_id = isset($_POST['content_id']) ? $_POST['content_id'] : '';
if (empty($trade_no) || empty($content_id)) {
    exit(json_encode(['code' => 0, 'msg' => '参数错误']));
}
if (isset($_POST['sign']) && isset($_POST['sign_type'])) {
    if (!verifySign($_POST, $option->pay_key, $_POST['sign'], $_POST['sign_type'])) {
        exit(json_encode(['code' => 0, 'msg' => '签名验证失败']));
    }
}
$tempDir = dirname(__FILE__) . '/temp';
$orderFile = $tempDir . '/' . $trade_no . '.json';

if (!file_exists($orderFile)) {
    exit(json_encode(['code' => 0, 'msg' => '订单不存在']));
}
$orderData = json_decode(file_get_contents($orderFile), true);
if (!$orderData) {
    exit(json_encode(['code' => 0, 'msg' => '订单数据错误']));
}
if ($orderData['content_id'] != $content_id) {
    exit(json_encode(['code' => 0, 'msg' => '内容ID不匹配']));
}
if ($orderData['status'] == 1) {
    exit(json_encode(['code' => 1, 'msg' => '支付成功']));
} else {
    exit(json_encode(['code' => 0, 'msg' => '未支付']));
}
function verifySign($data, $key, $sign, $signType = 'md5') {
    $filteredData = array_filter($data, function($v, $k) {
        return $v !== '' && $k !== 'sign' && $k !== 'sign_type';
    }, ARRAY_FILTER_USE_BOTH);
    ksort($filteredData);
    $signString = http_build_query($filteredData) . $key;
    switch (strtolower($signType)) {
        case 'sha256':
            return hash_equals(hash('sha256', $signString), $sign);
        default:
            return hash_equals(md5($signString), $sign);
    }
}