<?php
include '../../../config.inc.php';
date_default_timezone_set('Asia/Shanghai');
require_once __TYPECHO_ROOT_DIR__ . '/var/Typecho/Widget.php';
require_once __TYPECHO_ROOT_DIR__ . '/var/Typecho/Plugin.php';
$options = Typecho_Widget::widget('Widget_Options');
$option = $options->plugin('XBinPay');
if (empty($option->pay_pid) || empty($option->pay_key)) {
    exit('fail');
}
$trade_no = isset($_GET['trade_no']) ? $_GET['trade_no'] : '';
$out_trade_no = isset($_GET['out_trade_no']) ? $_GET['out_trade_no'] : '';
$type = isset($_GET['type']) ? $_GET['type'] : '';
$name = isset($_GET['name']) ? $_GET['name'] : '';
$money = isset($_GET['money']) ? $_GET['money'] : 0;
$trade_status = isset($_GET['trade_status']) ? $_GET['trade_status'] : '';
$sign = isset($_GET['sign']) ? $_GET['sign'] : '';
$sign_type = isset($_GET['sign_type']) ? $_GET['sign_type'] : '';
if (empty($out_trade_no) || empty($trade_status) || empty($sign)) {
    exit('fail');
}
if ($trade_status != 'TRADE_SUCCESS') {
    exit('fail');
}
if (!verifySign($_GET, $option->pay_key, $sign, $sign_type)) {
    exit('fail');
}
function verifySign($data, $key, $sign, $signType = 'md5') {
    $filteredData = array_filter($data, function($v, $k) {
        return $v !== '' && $k !== 'sign' && $k !== 'sign_type';
    }, ARRAY_FILTER_USE_BOTH);

    ksort($filteredData);
    $signString = http_build_query($filteredData) . $key;

    switch (strtolower($signType)) {
        case 'sha256':
            return hash_equals(hash('sha256', $signString), $sign);
        default:
            return hash_equals(md5($signString), $sign);
    }
}
$tempDir = dirname(__FILE__) . '/temp';
$orderFile = $tempDir . '/' . $out_trade_no . '.json';

if (!file_exists($orderFile)) {
    exit('fail');
}
$orderData = json_decode(file_get_contents($orderFile), true);
if (!$orderData) {
    exit('fail');
}
$orderData['status'] = 1; 
$orderData['pay_time'] = time();
$orderData['trade_no'] = $trade_no;
file_put_contents($orderFile, json_encode($orderData));
if (isset($option->emailNotify) && $option->emailNotify == '1') {
    require_once dirname(__FILE__) . '/include/EmailSender.php';
    XBinPay_EmailSender::sendPaymentNotification(
        $trade_no, 
        $orderData['price'],
        $name, 
        $type  
    );
}
exit('success');
function createSign($data, $key) {
    ksort($data);
    $sign = '';
    foreach ($data as $k => $v) {
        if ($k != 'sign' && $k != 'sign_type' && $v != '') {
            $sign .= $k . '=' . $v . '&';
        }
    }
    $sign = trim($sign, '&');
    $sign .= $key;
    return $sign;
}