<?php
if (!defined('__TYPECHO_ROOT_DIR__')) exit;
if (!class_exists('PHPMailer\\PHPMailer\\PHPMailer')) {
    require_once dirname(__FILE__) . '/PHPMailer/PHPMailer.php';
    require_once dirname(__FILE__) . '/PHPMailer/SMTP.php';
}
if (!class_exists('Typecho_Widget')) {
    require_once __TYPECHO_ROOT_DIR__ . '/var/Typecho/Widget.php';
}

class XBinPay_EmailSender {
    public static function sendPaymentNotification($trade_no, $price, $name = '', $type = '') {
        $options = Typecho_Widget::widget('Widget_Options');
        $option = $options->plugin('XBinPay');
        if (!isset($option->emailNotify) || $option->emailNotify != '1') {
            return ['status' => false, 'error' => '邮件通知未启用'];
        }
        $required = ['smtpHost', 'smtpPort', 'smtpUsername', 'smtpPassword', 'recipientEmail'];
        foreach ($required as $key) {
            if (empty($option->$key)) {
                return ['status' => false, 'error' => "缺少必要配置: $key"];
            }
        }
        $typeMap = [
            'alipay' => '支付宝',
            'wxpay' => '微信支付',
            'qqpay' => 'QQ支付'
        ];
        $typeName = $typeMap[$type] ?? $type;

        try {
            $mail = new PHPMailer\PHPMailer\PHPMailer(true);
            $mail->isSMTP();
            $mail->Host = $option->smtpHost;
            $mail->Port = $option->smtpPort;
            $mail->SMTPAuth = true;
            $mail->Username = $option->smtpUsername;
            $mail->Password = $option->smtpPassword;
            $mail->SMTPSecure = $option->smtpSecure ?? 'ssl';
            $mail->setFrom($option->smtpUsername, $option->smtpFromName ?? '网站通知');
            $mail->addAddress($option->recipientEmail);
            $mail->Subject = "XBinPay提醒，来订单了喔~";
            $displayName = empty($name) ? '未命名商品' : $name;
            $displayType = empty($typeName) ? '未知支付方式' : $typeName;
            
            $body = "又收到一笔巨款，真开森~\n";
            $body .= "订单号：$trade_no\n";
            $body .= "商品名称：$displayName\n";
            $body .= "支付方式：$displayType\n";
            $body .= "支付金额：¥$price\n"; 
            $body .= "支付时间：" . date('Y-m-d H:i:s');
            $mail->Body = $body;
            
            error_log("邮件发送参数: trade_no=$trade_no, price=$price, name=$name, type=$type");
            
            $sendResult = $mail->send();
            return [
                'status' => $sendResult,
                'error' => $mail->ErrorInfo,
                'debug' => [
                    'received_params' => [
                        'trade_no' => $trade_no,
                        'price' => $price,
                        'name' => $name,
                        'type' => $type
                    ],
                    'mail_config' => [
                        'host' => $option->smtpHost,
                        'username' => $option->smtpUsername
                    ]
                ]
            ];
            
        } catch (Exception $e) {
            error_log("邮件发送失败: " . $e->getMessage());
            return [
                'status' => false,
                'error' => $e->getMessage()
            ];
        }
    }

    public static function sendUpdateNotification($version, $content, $url = '') {
        $options = Typecho_Widget::widget('Widget_Options');
        $option = $options->plugin('XBinPay');
        if (!isset($option->emailNotify) || $option->emailNotify != '1') {
            return ['status' => false, 'error' => '邮件通知未启用'];
        }
        $required = ['smtpHost', 'smtpPort', 'smtpUsername', 'smtpPassword', 'recipientEmail'];
        foreach ($required as $key) {
            if (empty($option->$key)) {
                return ['status' => false, 'error' => "缺少必要配置: $key"];
            }
        }

        try {
            $mail = new PHPMailer\PHPMailer\PHPMailer(true);
            $mail->isSMTP();
            $mail->Host = $option->smtpHost;
            $mail->Port = $option->smtpPort;
            $mail->SMTPAuth = true;
            $mail->Username = $option->smtpUsername;
            $mail->Password = $option->smtpPassword;
            $mail->SMTPSecure = $option->smtpSecure ?? 'ssl';
            $mail->setFrom($option->smtpUsername, $option->smtpFromName ?? '网站通知');
            $mail->addAddress($option->recipientEmail);
            $mail->Subject = "【XBinPay插件】有新版本了-$version";
            
            $body = "XBinPay插件新版本新鲜出炉啦~ 

";
            $body .= "更新内容：
$content

";
            if (!empty($url)) {
                $body .= "更新地址：$url
";
            }
            $body .= "
通知时间：" . date('Y-m-d H:i:s');
            $mail->Body = $body;
            
            $sendResult = $mail->send();
            return [
                'status' => $sendResult,
                'error' => $mail->ErrorInfo
            ];
            
        } catch (Exception $e) {
            error_log("更新通知邮件发送失败: " . $e->getMessage());
            return [
                'status' => false,
                'error' => $e->getMessage()
            ];
        }
    }
}