<?php
if (!defined('__TYPECHO_ROOT_DIR__')) exit;
class XBinPay_CleanFiles {
    public static function checkAndCleanTempFiles() {
        $tempDir = dirname(__FILE__) . '/../temp';
        $lastCleanFile = $tempDir . '/last_clean.txt';
        if (!is_dir($tempDir)) {
            mkdir($tempDir, 0777, true);
            file_put_contents($lastCleanFile, date('Y-m-d'));
            return;
        }
        $options = Typecho_Widget::widget('Widget_Options');
        $option = $options->plugin('XBinPay');
        $cleanDays = isset($option->cleanDays) ? intval($option->cleanDays) : 7;
        if ($cleanDays < 1) {
            $cleanDays = 1;
        }
        $needClean = false;
        if (file_exists($lastCleanFile)) {
            $lastCleanDate = trim(file_get_contents($lastCleanFile));
            $lastCleanTime = strtotime($lastCleanDate);
            $currentTime = time();
            if (($currentTime - $lastCleanTime) >= ($cleanDays * 86400)) {
                $needClean = true;
            }
        } else {
            file_put_contents($lastCleanFile, date('Y-m-d'));
        }
        if ($needClean) {
            $files = glob($tempDir . '/*');
            foreach ($files as $file) {
                if (basename($file) != 'last_clean.txt' && basename($file) != 'domain.txt') {
                    @unlink($file);
                }
            }
            file_put_contents($lastCleanFile, date('Y-m-d'));
        }
    }
}