<?php
/**
 * XBinPay付费阅读【授权版】更多功能持续更新....
 * 
 * @package XBinPay
 * @author 彬彬
 * @version 2.0.3
 * @link https://www.52bin.cn/introduce.html
 */
class XBinPay_Plugin implements Typecho_Plugin_Interface {
    /**
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function activate() {
        Typecho_Plugin::factory('Widget_Abstract_Contents')->contentEx = array('XBinPay_Plugin', 'parse');
        Typecho_Plugin::factory('Widget_Abstract_Contents')->excerpt = array('XBinPay_Plugin', 'filterExcerpt');
        Typecho_Plugin::factory('Widget_Archive')->footer = array('XBinPay_Plugin', 'footer');
        $tempDir = dirname(__FILE__) . '/temp';
        if (!is_dir($tempDir)) {
            mkdir($tempDir, 0777, true);
        }
        require_once dirname(__FILE__) . '/include/DomainManager.php';
        XBinPay_DomainManager::initDomainTable();
        return _t('插件已经激活，需先配置插件信息！');
    }
    /**
     * @static
     * @access public
     * @return void
     * @throws Typecho_Plugin_Exception
     */
    public static function deactivate() {
        return _t('插件已被禁用');
    }
    /**
     * @access public
     * @param Typecho_Widget_Helper_Form $form 配置面板
     * @return void
     */
    public static function config(Typecho_Widget_Helper_Form $form) {
        $options = Typecho_Widget::widget('Widget_Options');
        $plug_url = $options->pluginUrl;
        $div = new Typecho_Widget_Helper_Layout();
        $div->html('<small>
           <h3>XBinPay介绍说明：</h3>
            <p>感谢使用XBinPay付费阅读插件(v2.0.3)，本插件为授权版，会持续更新优化更多功能~</p>
            <p>仅支持个人授权使用，禁止用于商业违法等用途！！！</p>
            <p>疑问请联系微信：ibin0513 QQ群：422505146（留意版本更新）</p>
            <p>注：代搭建网站☝解决网站代码问题、优化功能
            <h3>食用方法：</h3>
            <span><p>第一步：配置下方各项参数；</p></span>
            <span>
                <p>
                    第二步：在文章中使用插入以下代码：
                </p>
				<p>
                    <font color="blue">{XBinPay money=支付的金额}付费后显示的内容{/XBinPay}</font>
                </p>
            </span>
        </small>');
        $div->render();
        $pay_pid = new Typecho_Widget_Helper_Form_Element_Text('pay_pid', array('value'), "", _t('商户PID'), _t('填写商户PID。'));
        $form->addInput($pay_pid);
        $pay_key = new Typecho_Widget_Helper_Form_Element_Text('pay_key', array('value'), "", _t('商户KEY'), _t('填写商户KEY。'));
        $form->addInput($pay_key);
        $pay_url = new Typecho_Widget_Helper_Form_Element_Text('pay_url', array('value'), "", _t('支付网关'), _t('填写易支付网关。如：https://pay.52bin.cn/'));
        $form->addInput($pay_url);
        $pay_notify_url = new Typecho_Widget_Helper_Form_Element_Text('pay_notify_url', array('value'), $plug_url.'/XBinPay/notify_url.php', _t('异步回调接口'), _t('支付完成后异步回调的接口地址。'));
        $form->addInput($pay_notify_url);
        $payMethods = new Typecho_Widget_Helper_Form_Element_Checkbox('payMethods', array(
            'alipay' => _t('支付宝'),
            'wxpay' => _t('微信支付'),
            'qqpay' => _t('QQ支付')
        ), array('alipay', 'wxpay', 'qqpay'), _t('支付方式'), _t("勾选需要开启的支付方式"));
        $form->addInput($payMethods);
        $cleanDays = new Typecho_Widget_Helper_Form_Element_Text(
            'cleanDays', 
            array('value'), 
            "7", 
            _t('自动清理订单(付费内容可见天数)'), 
            _t('设置多少天后自动清理订单，不能小于1天。默认为7天')
        );
        $form->addInput($cleanDays->addRule('required', _t('必须填写自动清理天数'))
                        ->addRule('isInteger', _t('清理天数必须是整数'))
                        ->addRule('min', _t('清理天数不能小于1天'), 1));
        $div = new Typecho_Widget_Helper_Layout();
        $div->html('<h3>邮件通知设置</h3>');
        $form->addItem($div);
        $smtpHost = new Typecho_Widget_Helper_Form_Element_Text(
            'smtpHost',
            array('value'),
            '',
            _t('SMTP 主机名'),
            _t('例如：smtp.qq.com')
        );
        $form->addInput($smtpHost);
        $smtpPort = new Typecho_Widget_Helper_Form_Element_Text(
            'smtpPort',
            array('value'),
            '465',
            _t('SMTP 端口'),
            _t('一般为 465（SSL）或 587（TLS）')
        );
        $form->addInput($smtpPort);
        $smtpSecure = new Typecho_Widget_Helper_Form_Element_Radio(
            'smtpSecure',
            array('ssl' => _t('SSL'), 'tls' => _t('TLS')),
            'ssl',
            _t('加密方式'),
            _t('根据你的邮件服务商要求选择')
        );
        $form->addInput($smtpSecure);
        $smtpUsername = new Typecho_Widget_Helper_Form_Element_Text(
            'smtpUsername',
            array('value'),
            '',
            _t('SMTP 用户名'),
            _t('通常是你的邮箱地址')
        );
        $form->addInput($smtpUsername);
        $smtpPassword = new Typecho_Widget_Helper_Form_Element_Password(
            'smtpPassword',
            array('value'),
            '',
            _t('SMTP 密码'),
            _t('可能是邮箱密码或授权码，取决于邮件服务商')
        );
        $form->addInput($smtpPassword);
        $smtpFromName = new Typecho_Widget_Helper_Form_Element_Text(
            'smtpFromName',
            array('value'),
            'XBinPay付费阅读',
            _t('发件人名称'),
            _t('显示的发件人名称')
        );
        $form->addInput($smtpFromName);
        $recipientEmail = new Typecho_Widget_Helper_Form_Element_Text(
            'recipientEmail',
            array('value'),
            '',
            _t('收件人邮箱'),
            _t('接收收款通知的邮箱地址，站长邮箱')
        );
        $form->addInput($recipientEmail);
        $emailNotify = new Typecho_Widget_Helper_Form_Element_Radio(
            'emailNotify',
            array('0' => _t('关闭'), '1' => _t('开启')),
            '0',
            _t('开启邮件通知'),
            _t('开启后，用户支付成功将发送邮件通知站长')
        );
        $form->addInput($emailNotify);
    }
    /**
     * @access public
     * @param Typecho_Widget_Helper_Form $form
     * @return void
     */
    public static function personalConfig(Typecho_Widget_Helper_Form $form) {}
    private static function loadModules() {
        static $loaded = false;
        
        if (!$loaded) {
            require_once dirname(__FILE__) . '/include/Loader.php';
            XBinPay_Loader::init();
            $loaded = true;
        }
    }
    /**
     * @access public
     * @param string $content 摘要内容
     * @param Widget_Abstract_Contents $widget 文章对象
     * @return string
     */
    public static function filterExcerpt($content, $widget) {
        self::loadModules();
        return XBinPay_ContentParser::filterExcerpt($content, $widget);
    }
    /**
     * @access public
     * @param string $content 文章内容
     * @param Widget_Abstract_Contents $widget 文章对象
     * @return string
     */
    public static function parse($content, $widget) {
        self::loadModules();
        return XBinPay_ContentParser::parse($content, $widget);
    }
    /**
     * @access public
     * @return void
     */
    public static function footer() {
        self::loadModules();
        XBinPay_Footer::output();
    }
}